define(['angular', 'app', 'moment'], function (angular, app, moment) {
	'use strict';

	app.controller('TrackersSummaryController', function ($scope, $filter, $state, $stateParams, $http, authenticationService, TrackersService, TrackersRemindersService, TrackersConstants, GraphService, focusService, formatter, localResourceDirectoryService) {
		var service = $stateParams.section.service || TrackersService.instance($stateParams.section);

		$scope.notificationDetails = {
			notificationStatus: ''
		};

		$scope.currentSection = $stateParams.section;
		$scope.summaryType = 'table';
		$scope.sectionTitle = $state.current.data.sectionName || $filter('filter')($state.current.data.paramSections, { paramValue: $stateParams.section }, true)[0].sectionName;
		angular.extend($scope, TrackersConstants[$stateParams.section].summary);

		TrackersRemindersService.init($stateParams.section);
		TrackersRemindersService.getReminder(TrackersConstants[$stateParams.section].name).then(function (response) {
			$scope.notificationDetails = angular.copy(response);
		});

		// date range specific to Glucose trackers for now, may change for other trackers
		var minDate = moment().subtract(6,'year').format('L'),
			defaultMin = ($stateParams.section === 'fitness-activity' || $stateParams.section === 'fitness-goals'?
				moment().subtract(90,'day') :
				moment().subtract(1,'year')).format('L'),
			defaultMax = moment().format('L'),
			defaultFilters = {
				startDate: defaultMin,
				endDate: defaultMax
			};
		
		$scope.allowedDateRange = { min: minDate };

		$scope.filter = {
			service: service,
			defaults: defaultFilters,
			model: defaultFilters,
			callbacks: {
				filter: function (items) {
					makeGraph();
				}
			}
		};

		if ($stateParams.section === 'fitness-goals') {
			
			$scope.navButtons = {
				left: [],
				right: []
			};


		} else {
			$scope.navButtons = {
				right: [],
				left: []
			};
		}
		 

		var graphMetaData = TrackersConstants[$stateParams.section].entry.vitalObservationsMeta;

		// internal functions
		var makeGraph = function() {
			if (graphMetaData) {
				$scope.graphConfig = GraphService.getGraphConfig($stateParams.section, service.dataPointers.filters || $scope.filter.model || $scope.filter.defaults, service.dataPointers.list, graphMetaData, $scope.sectionTitle);
			}
		};

		if (graphMetaData) {
			// filter nav buttons
			var navGraphButton = {
				getLabel : function() {
					return $scope.summaryType === 'graph' ? 'Table' : 'Graph';
				},
				getIcon : function() {
					return $scope.summaryType === 'graph' ? 'icon-list' : 'icon-graph';
				},
				onClick : function() {
					$scope.summaryType = $scope.summaryType === 'graph' ? 'table' : 'graph';
					$scope.filter.noFocus = $scope.summaryType === 'graph';
				}
			};

			$scope.navButtons.right.push(navGraphButton);
		}

		var notificationButton = {
			getLabel: function() {
				return 'Notification (' + $scope.notificationDetails.notificationStatus + ')';
			},
			getIcon: function() {
				return 'icon-notification';
			},
			onClick: function() {
				$state.go('^.notification', $stateParams);
			}
		};

		$scope.navButtons.right.push(notificationButton);

		$scope.getDetails = function (item) {
			$stateParams.id = item ? service.idGetter ? service.idGetter(item) : item.id : null;
			$state.go('^.entry', $stateParams);
		};

		if (!service.dataPointers.list) {
			service.fetch($scope.filter.defaults).then(function (response) {
				makeGraph();
			});
		} else {
			makeGraph();
		}
	});
});